// XISLCombIntputTag.cpp: CXISLCombInputTag NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLCombInputTag.h"
#include "XISLInputTag.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////
CXISLCombInputTag::CXISLCombInputTag(CXISLTag *pParent,int nType)
{
	m_pParentTag = pParent;
	switch(nType)
	{
	case ID_TAG_SEQ:
		m_nTagType = ID_TAG_SINPUT;
		m_nBmpID = IDB_SEQ;
		break;
	case ID_TAG_PAR:
		m_nTagType = ID_TAG_PINPUT;
		m_nBmpID = IDB_PAR;
		break;
	case ID_TAG_ALT:
		m_nTagType = ID_TAG_AINPUT;
		m_nBmpID = IDB_ALT;
		break;
	default:
		ASSERT(NULL);
		break;
	}
}

CXISLCombInputTag::~CXISLCombInputTag()
{
	for(int i=0; i<m_InputList.GetCount(); i++)
	{
		POSITION pos = m_InputList.FindIndex(i);
		CXISLOprItem *pOprItem = (CXISLOprItem*)m_InputList.GetAt(pos);
		if(pOprItem->m_nTagType == ID_TAG_INPUT)
			delete (CXISLInputTag*)pOprItem;
		else
			delete (CXISLCombInputTag*)pOprItem;
	}
}

CXISLCombInputTag::CXISLCombInputTag(const CXISLCombInputTag &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;

	for(int i=0; i<cpXISL.m_InputList.GetCount(); i++)
	{
		POSITION pos = cpXISL.m_InputList.FindIndex(i);
		m_InputList.AddTail(cpXISL.m_InputList.GetAt(pos));
	}
}

CXISLCombInputTag& CXISLCombInputTag::operator=(const CXISLCombInputTag &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;

		for(int i=0; i<m_InputList.GetCount(); i++)
		{
			POSITION pos = m_InputList.FindIndex(i);
			CXISLOprItem *pOprItem = (CXISLOprItem*)m_InputList.GetAt(pos);
			if(pOprItem->m_nTagType == ID_TAG_INPUT)
				delete (CXISLInputTag*)pOprItem;
			else
				delete (CXISLCombInputTag*)pOprItem;
		}
		m_InputList.RemoveAll();
		for(i=0; i<cpXISL.m_InputList.GetCount(); i++)
		{
			POSITION pos = cpXISL.m_InputList.FindIndex(i);
			m_InputList.AddTail(cpXISL.m_InputList.GetAt(pos));
		}
	}
	return *this;
}

void CXISLCombInputTag::InsertOprItem(CXISLOprItem *pTag,CXISLTag *pPlaceTag)
{
	if(pPlaceTag)
	{
		POSITION pos = m_InputList.Find(pPlaceTag);
		if(pos)
		{
			if(pTag->m_nTagType == ID_TAG_INPUT)
			{
				if((pPlaceTag->m_nTagType!=ID_TAG_PINPUT && pPlaceTag->m_nTagType!=ID_TAG_AINPUT
					&& pPlaceTag->m_nTagType!=ID_TAG_SINPUT))
					ASSERT(NULL);
				
				((CXISLCombInputTag*)pPlaceTag)->InsertOprItem(pTag);
			}
			else if(pTag->m_nTagType == ID_TAG_PINPUT || pTag->m_nTagType == ID_TAG_SINPUT
				|| pTag->m_nTagType == ID_TAG_AINPUT)
			{
				//pPlaceTagpTagւăXgɑ}
				pTag->m_pParentTag = m_pParentTag;
				m_InputList.InsertAfter(pos,pTag);
				m_InputList.RemoveAt(pos);
				((CXISLCombInputTag*)pTag)->InsertOprItem((CXISLOprItem*)pPlaceTag);
			}
		}
		else
			ASSERT(NULL);
	}
	else
	{
		m_InputList.AddTail(pTag);
		pTag->m_pParentTag = m_pParentTag;
	}
}

//폜
//2003/5/14@
BOOL CXISLCombInputTag::DeleteOprItem(CXISLOprItem *pTag,CXISLTag *pPlaceTag)
{
	POSITION pos = m_InputList.Find(pTag);
	if(pos==NULL)return FALSE;
	POSITION posdel = pos;
	m_InputList.RemoveAt(posdel);
	delete pTag;
	pTag=NULL;
	return TRUE;
}

void CXISLCombInputTag::DeleteCombInputList()
{
	CXISLOprItem *pOprTag;
	CXISLCombInputTag *pCTag;
	while(!m_InputList.IsEmpty()){
		pOprTag = (CXISLOprItem *)m_InputList.GetHead();
		if(pOprTag->m_nTagType == ID_TAG_INPUT){
			DeleteOprItem(pOprTag);
		}
		else if(pOprTag->m_nTagType == ID_TAG_SINPUT || pOprTag->m_nTagType == ID_TAG_PINPUT || pOprTag->m_nTagType == ID_TAG_AINPUT){
			pCTag = (CXISLCombInputTag *)m_InputList.GetHead();
			pCTag->DeleteCombInputList();
			DeleteOprItem(pCTag);
		}
	}
}

//BOOL CXISLOprTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
//@\@Fc[Rg[XISL^Oo^
//@FCTreeCtrl *pTree  :o^c[Rg[
//		  HTREEITEM hParent :eڂ̃nh
//ԂlFBOOL@FTRUE@sFFALSE
BOOL CXISLCombInputTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
{
//	if(m_InputList.GetCount() == 0)
//		return TRUE;

	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = hParent;

	//c[ɓo^
	tvi.pszText = XISL_TAG_NAME[m_nTagType];
	tvi.lParam = (LPARAM)this;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	hParent = pTree->InsertItem(&tvs);
	m_htreeItem = hParent;

	for(int i=0; i<m_InputList.GetCount(); i++)
	{
		POSITION pos = m_InputList.FindIndex(i);
		CXISLOprItem *pOprItem = (CXISLOprItem*)m_InputList.GetAt(pos);

		pOprItem->RegistXISLTree(pTree,hParent);
	}

	return TRUE;
}


//LPCTSTR CXISLCombInputTag::GetXISLString()
//@\@FinputȉXISLԂ
//@F
//ԂlFLPCTSTRCXISL
LPCTSTR CXISLCombInputTag::GetXISLString()
{
	m_strXISL = "<";
	m_strXISL += XISL_TAG_NAME[m_nTagType];
	m_strXISL += ">\r\n";

	for(int i=0; i<m_InputList.GetCount(); i++)
	{
		POSITION pos = m_InputList.FindIndex(i);
		CXISLOprItem *pOprItem = (CXISLOprItem*)m_InputList.GetAt(pos);

		m_strXISL += pOprItem->GetXISLString();
	}

	m_strXISL += "</";
	m_strXISL += XISL_TAG_NAME[m_nTagType];
	m_strXISL += ">\r\n";

	return m_strXISL;
}

//CXISLTag* CXISLCombInputTag::FindTag(POINT point,BOOL bOnly)
//@\@FNbNꂽ^OT
//@Fpoint:W
//		  bOnly:TRUE͎̎ĝݔf
//ԂlFY^OBNULL
CXISLTag* CXISLCombInputTag::FindTag(POINT point,BOOL bOnly)
{
	m_rectBMP.NormalizeRect();
	if(m_rectBMP.PtInRect(point))
		return (CXISLTag*)this;
	else if(!bOnly)
	{
		CXISLTag* pTag;
		for(int i=0;i<m_InputList.GetCount();i++)
		{
			POSITION pos = m_InputList.FindIndex(i);
			CXISLOprItem* pOprItem = (CXISLOprItem*)m_InputList.GetAt(pos);

			pTag = pOprItem->FindTag(point,TRUE);
			if(pTag)
				return pTag;
		}
	}

	return NULL;
}

//CSize CXISLCombInputTag::DrawXISLFlow(CDC *pDC,int nX,int nY)
//@\@F***_exchange̗}
//@FCDC *pDC:foCXReLXg
//		  int nX, nY:`Jnʒu
//ԂlFCSize:`͈
CSize CXISLCombInputTag::DrawXISLFlow(CDC *pDC,int nX,int nY)
{
	int nViewSizeX,nViewSizeY;

	CDC MemDC;
	MemDC.CreateCompatibleDC(pDC);
		
	CBitmap FlowBMP;
	BITMAP bmp;

	//1D܂͎g`
	FlowBMP.LoadBitmap(m_nBmpID);
	FlowBMP.GetBitmap(&bmp);
	CBitmap *pOldBMP = MemDC.SelectObject(&FlowBMP);

	pDC->BitBlt(nX,nY,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
	FlowBMP.DeleteObject();
	SetRectBMP(nX,nY,bmp.bmWidth,bmp.bmHeight);

	nX += bmp.bmWidth/2;
	nY += bmp.bmHeight-1;
	pDC->MoveTo(nX,nY);

	POINT point[3];
	point[0].x = nX;
	nY += 20;
	point[0].y = nY;
	nX += bmp.bmWidth;
	point[1].x = nX+5;
	point[1].y = nY;
	point[2].x = nX;
	nY += 35;
	point[2].y = nY;

	nViewSizeX = nX;

	CPen *pOldPen,linePen;
	linePen.CreatePen(PS_SOLID,3,RGB(0,0,0));
	pOldPen = pDC->SelectObject(&linePen);

	pDC->PolyBezierTo(point,3);
	
	int nCount = m_InputList.GetCount();
	//exchangeOȂ`
	if(nCount == 0)
	{
		pDC->MoveTo(nX+4,nY-6);
		pDC->LineTo(nX,nY);
		pDC->MoveTo(nX-4,nY-6);
		pDC->LineTo(nX,nY);
	}
	else
	{
		int nBX = nX;
		int nBY = nY;
		int *npInputPoint = new int[nCount];
		nY += 20;
		for(int i=0;i<nCount;i++)
		{
			POSITION pos = m_InputList.FindIndex(i);
			CXISLOprItem *pOprItem = (CXISLOprItem*)m_InputList.GetAt(pos);

			FlowBMP.LoadBitmap(pOprItem->m_nBmpID);
			FlowBMP.GetBitmap(&bmp);
			if(m_nTagType != ID_TAG_SINPUT && i==0)
			{
				nX = nX - (bmp.bmWidth - 10);
				nY += 50;
			}
			MemDC.SelectObject(&FlowBMP);
			pDC->BitBlt(nX-bmp.bmWidth/2,nY,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
			pOprItem->SetRectBMP(nX-bmp.bmWidth/2,nY,bmp.bmWidth,bmp.bmHeight);
			npInputPoint[i] = nX;
			nViewSizeX = nX + bmp.bmWidth/2;

			pDC->MoveTo(nBX,nBY);
			if(m_nTagType != ID_TAG_SINPUT)
			{
				if(i == 0)
				{
					point[0].x = nBX;
					point[0].y = nBY+20;
					point[1].x = nX-10;
					point[1].y = nBY+20;
					point[2].x = nX;
					point[2].y = nY;
				}
				else
				{
					point[0].x = nBX;
					point[0].y = nBY+20;
					point[1].x = nX+10;
					point[1].y = nBY+20;
					point[2].x = nX;
					point[2].y = nY;
				}
				pDC->PolyBezierTo(point,3);
				//`
				pDC->MoveTo(nX+4,nY-6);
				pDC->LineTo(nX,nY);
				pDC->MoveTo(nX-4,nY-6);
				pDC->LineTo(nX,nY);
				nX = nX + bmp.bmWidth + 20;
			}
			else
			{
				pDC->LineTo(nX,nY);
				nBX = nX; nBY = nY + bmp.bmHeight;
				//`
				pDC->MoveTo(nX+4,nY-6);
				pDC->LineTo(nX,nY);
				pDC->MoveTo(nX-4,nY-6);
				pDC->LineTo(nX,nY);
				nY = nY + bmp.bmHeight + 20;
			}

			FlowBMP.DeleteObject();
		}

		if(m_nTagType == ID_TAG_SINPUT)
		{
			pDC->MoveTo(nBX,nBY);
			nY += 10;
			pDC->LineTo(nX,nY);
		}
		else
		{
			nX = nBX;
			nY += bmp.bmHeight;
			nBY = nY; 
			if(m_nTagType == ID_TAG_PINPUT)
			{
				nY += 20;
				for(int i=0;i<nCount;i++)
				{
					pDC->MoveTo(npInputPoint[i],nBY);
					pDC->LineTo(npInputPoint[i],nY);
				}
				pDC->MoveTo(npInputPoint[0],nY);
				if(nCount == 1)
					pDC->LineTo(nBX,nY);
				else
					pDC->LineTo(npInputPoint[nCount-1],nY);
				pDC->MoveTo(nBX,nY);
				nY += 30;
				pDC->LineTo(nBX,nY);
			}
			else if(m_nTagType == ID_TAG_AINPUT)
			{
				nY += 60;
				for(int i=0;i<nCount;i++)
				{
					pDC->MoveTo(npInputPoint[i],nBY);
					if(i == 0)
					{
						point[0].x = npInputPoint[i]+10;
						point[0].y = nBY+20;
						point[1].x = npInputPoint[i]-10;
						point[1].y = nBY+20;
						point[2].x = nX;
						point[2].y = nY;
					}
					else
					{
						point[0].x = npInputPoint[i];
						point[0].y = nBY+20;
						point[1].x = npInputPoint[i]+10;
						point[1].y = nBY+40;
						point[2].x = nX;
						point[2].y = nY;
					}
					pDC->PolyBezierTo(point,3);
				}
			}
		}
		nY += 10;
		pDC->LineTo(nX,nY);
		//`
		pDC->MoveTo(nX+4,nY-6);
		pDC->LineTo(nX,nY);
		pDC->MoveTo(nX-4,nY-6);
		pDC->LineTo(nX,nY);
		delete [] npInputPoint;
	}

	nViewSizeY = nY;

	MemDC.SelectObject(pOldBMP);
	MemDC.DeleteDC();

	return CSize(nViewSizeX+100,nViewSizeY+100);
}

